---
generated_at: 2026-01-27 12:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-Menubar - Add 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/js/Menubar.Add.js` - Addメニューの実装ファイル（511行）
- E-02: `editor/js/commands/AddObjectCommand.js` - オブジェクト追加コマンド（69行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Group追加はnew THREE.Group()を使用 | E-01 (30行目) | ○ |
| C-02 | Groupのnameは'Group'に設定される | E-01 (31行目) | ○ |
| C-03 | BoxGeometryのパラメータは(1,1,1,1,1,1) | E-01 (68行目) | ○ |
| C-04 | CapsuleGeometryのパラメータは(1,1,4,8,1) | E-01 (84行目) | ○ |
| C-05 | CircleGeometryのパラメータは(1,32,0,Math.PI*2) | E-01 (101行目) | ○ |
| C-06 | CylinderGeometryのパラメータは(1,1,1,32,1,false,0,Math.PI*2) | E-01 (117行目) | ○ |
| C-07 | SphereGeometryのパラメータは(1,32,16,0,Math.PI*2,0,Math.PI) | E-01 (230行目) | ○ |
| C-08 | TorusGeometryのパラメータは(1,0.4,12,48,Math.PI*2) | E-01 (277行目) | ○ |
| C-09 | TorusKnotGeometryのパラメータは(1,0.4,64,8,2,3) | E-01 (293行目) | ○ |
| C-10 | すべてのメッシュにMeshStandardMaterialが使用される | E-01 (69, 102, 118行目等) | ○ |
| C-11 | LatheジオメトリはDoubleSideマテリアルを使用 | E-01 (166行目) | ○ |
| C-12 | AmbientLightのcolorは0x222222 | E-01 (356行目) | ○ |
| C-13 | DirectionalLightのpositionは(5,10,7.5) | E-01 (380行目) | ○ |
| C-14 | HemisphereLightのskyColorは0x00aaff、groundColorは0xffaa00 | E-01 (394-395行目) | ○ |
| C-15 | SpotLightのangleはMath.PI*0.1 | E-01 (437行目) | ○ |
| C-16 | OrthographicCameraはeditor.camera.aspectを使用 | E-01 (482行目) | ○ |
| C-17 | サブメニューはonMouseOverで表示される | E-01 (41-48行目) | ○ |
| C-18 | サブメニューはonMouseOutで非表示になる | E-01 (51-53行目) | ○ |
| C-19 | getBoundingClientRect()で位置を取得 | E-01 (43行目) | ○ |
| C-20 | AddObjectCommandを使用してオブジェクトを追加 | E-01 (33, 72, 105行目等) | ○ |
| C-21 | DirectionalLightはtargetも設定される | E-01 (378行目) | ○ |
| C-22 | SpotLightはtargetも設定される | E-01 (442行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張についてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [x] Mesh追加処理（16種類）の実装が正しく記載されているか
- [x] Light追加処理（5種類）のデフォルトパラメータが正確か
- [x] Camera追加処理（2種類）の実装が正確か
- [x] サブメニューの表示/非表示ロジックが正確か
- [x] 関連機能一覧が画面機能マッピングと一致しているか
